@echo off
setlocal enabledelayedexpansion

set "SCRIPT_DIR=%~dp0"

if exist "%SCRIPT_DIR%ffmpeg.exe" (
    set "FFMPEG=%SCRIPT_DIR%ffmpeg.exe"
) else (
    set "FFMPEG=ffmpeg.exe"
)

set "ROOT=%~1"

if "%ROOT%"=="" (
    echo Glissez un dossier sur ce fichier .bat ou lancez :
    echo mp3_to_mp4.bat "C:\chemin\vers\dossier"
    pause
    exit /b
)

set "OUT=%ROOT%\convert"
if not exist "%OUT%" mkdir "%OUT%"

set "PNG="

for %%I in ("%ROOT%\*.png") do (
    set "PNG=%%I"
    goto :foundpng
)

echo Aucun PNG trouve dans "%ROOT%"
pause
exit /b

:foundpng
echo PNG trouve : %PNG%

for %%M in ("%ROOT%\*.mp3") do (
    echo Traitement de %%M

    %FFMPEG% -y -loop 1 -i "%PNG%" -i "%%M" ^
    -filter_complex "[0:v]scale=1920:1080:force_original_aspect_ratio=increase,crop=1920:1080,boxblur=30[bg];[0:v]scale=-1:800:force_original_aspect_ratio=decrease[fg];[bg][fg]overlay=(W-w)/2:(880-h)/2[lay];[1:a]showwaves=s=1920x200:mode=line:rate=25:colors=white[wave];[lay][wave]overlay=0:880" ^
    -c:v libx264 -preset medium -crf 18 -c:a copy -shortest "%OUT%\%%~nM.mp4"
)

echo Conversion terminee dans %OUT%
pause
